/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import jgamebase.Const;

public class Preferences {
    public static final String SELECTED_VIEW = "selected_view";
    public static final String SELECTED_ITEM = "selected_item";
    public static final String WINDOW_POSITION_X = "window_position_x";
    public static final String WINDOW_POSITION_Y = "window_position_y";
    public static final String WINDOW_SIZE_X = "window_size_x";
    public static final String WINDOW_SIZE_Y = "window_size_y";
    public static final String CATEGORY_POSITION_X = "category_position_x";
    public static final String CATEGORY_POSITION_Y = "category_position_y";
    public static final String CATEGORY_SIZE_X = "category_size_x";
    public static final String CATEGORY_SIZE_Y = "category_size_y";
    public static final String SIDEBAR_WIDTH = "sidebar_width";
    public static final String SIDEBAR_H_DIVIDER = "sidebar_h_divider";
    public static final String SIDEBAR_V_DIVIDER = "sidebar_v_divider";
    public static final String DISPLAY_DETAILS = "display_details";
    public static final String SOUND_ON_CLASSICS = "sound_on_classics";
    public static final String HARDWARE_JOYSTICK = "hardware_joystick";
    public static final String ADULT_FILTER = "adult_filter";
    public static final String ADULT_FILTER_PW = "adult_filter_pw";
    public static final String ABOUT_SINCE = "about_since";
    public static final String ABOUT_GAMES_PLAYED = "about_games_played";
    public static final String ABOUT_MUSIC_PLAYED = "about_music_played";
    public static final String OVERLAY_VERSION = "overlay_version";
    public static final String GAME_STOP_RUNNING = "game_stop_running";
    public static final String EXTRA_OPEN_DOCUMENT_CMD = "extra_open_document_cmd";
    public static final String EXTRA_OPEN_IMAGE_CMD = "extra_open_image_cmd";
    public static final String EXTRA_SHOW_FILENAMES = "extras_show_filenames";
    protected String filename;
    protected Properties properties;

    public Preferences(String filename) {
        this.filename = filename;
        try {
            this.load();
        }
        catch (IOException iOException) {}
        this.setDefault(SELECTED_VIEW, "0");
        this.setDefault(SELECTED_ITEM, "");
        this.setDefault(WINDOW_POSITION_X, "0");
        this.setDefault(WINDOW_POSITION_Y, "0");
        this.setDefault(WINDOW_SIZE_X, "640");
        this.setDefault(WINDOW_SIZE_Y, "480");
        this.setDefault(CATEGORY_POSITION_X, "0");
        this.setDefault(CATEGORY_POSITION_Y, "0");
        this.setDefault(CATEGORY_SIZE_X, "240");
        this.setDefault(CATEGORY_SIZE_Y, "180");
        this.setDefault(SIDEBAR_WIDTH, "320");
        this.setDefault(SIDEBAR_H_DIVIDER, "-1");
        this.setDefault(SIDEBAR_V_DIVIDER, "-1");
        this.setDefault(DISPLAY_DETAILS, "true");
        this.setDefault(SOUND_ON_CLASSICS, "true");
        this.setDefault(HARDWARE_JOYSTICK, "false");
        this.setDefault(ADULT_FILTER, "false");
        this.setDefault(ADULT_FILTER_PW, "");
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("dd MMM yyyy");
        this.setDefault(ABOUT_SINCE, df.format(new Date()));
        this.setDefault(ABOUT_GAMES_PLAYED, "0");
        this.setDefault(ABOUT_MUSIC_PLAYED, "0");
        this.setDefault(GAME_STOP_RUNNING, "true");
        this.setDefault(EXTRA_OPEN_DOCUMENT_CMD, Const.OS_IS_WINDOWS ? "start" : "xdg-open");
        this.setDefault(EXTRA_OPEN_IMAGE_CMD, Const.OS_IS_WINDOWS ? "" : "xdg-open");
        this.setDefault(EXTRA_SHOW_FILENAMES, "false");
        this.setDefault(OVERLAY_VERSION, "19000101");
        this.save();
    }

    protected void load() throws IOException {
        File file = new File(this.filename);
        this.properties = new Properties();
        try (FileInputStream in = null;){
            try {
                in = new FileInputStream(file);
                this.properties.load(in);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    protected void setDefault(String key, String value) {
        this.properties.put(key, this.properties.getProperty(key, value));
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public int getInt(String key) {
        int i = 0;
        try {
            i = Integer.parseInt(this.properties.getProperty(key));
        }
        catch (NumberFormatException numberFormatException) {}
        return i;
    }

    public long getLong(String key) {
        long l = 0L;
        try {
            l = Long.parseLong(this.properties.getProperty(key));
        }
        catch (NumberFormatException numberFormatException) {}
        return l;
    }

    public boolean is(String key) {
        return "true".equalsIgnoreCase(this.properties.getProperty(key)) || "yes".equalsIgnoreCase(this.properties.getProperty(key));
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
        this.save();
    }

    public void set(String key, int value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }

    public void set(String key, long value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }

    public void set(String key, boolean value) {
        this.properties.setProperty(key, String.valueOf(value));
        this.save();
    }

    public void inc(String key) {
        this.set(key, this.getInt(key) + 1);
    }

    protected void save() {
        File file = new File(this.filename);
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                this.properties.store(out, "Properties written by jGameBase");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }
}

